<?php
class Landingcontent_Model extends CI_Model{
        
        function insert($arr)
        {
                
                $this->db->insert('landing_content', $arr);
                return $this->db->insert_id();
                
        }
        
        function update($id, $arr)
        {
        
                $this->db->where('id', $id);
                $this->db->update('landing_content', $arr);
        
        }
        
        function get()
        {       

                    $this->db->select('landing_content.id,landing_content.main_id,landing_main.title as main_title,landing_content.submenu_id,landing_submenu.title as submenu_title,landing_content.title,landing_content.main_content, landing_content.displayorder, landing_content.updated,landing_main.displayorder as maindisplayorder, landing_submenu.displayorder as submenudisplayorder ');
                    
                    $this->db->order_by("maindisplayorder", "asc");
                    $this->db->order_by("submenudisplayorder", "asc");
                    $this->db->order_by("displayorder","asc");
                    $this->db->from('landing_content');
                    $this->db->join('landing_main', 'landing_content.main_id = landing_main.id');
                    $this->db->join('landing_submenu', 'landing_content.submenu_id = landing_submenu.id');
                    $query=$this->db->get();

                return $query->result();
        }
        
        function get_id($id){
                $this->db->where('id', $id);
                $query = $this->db->get('landing_content');
                return $query->result();
        }
        
        function get_lang($lang)
        {
                
                $this->db->where('lang', $lang);
                $query = $this->db->get('landing_content');
                return $query->result();
                
        }
        
        function delete($id)
        {
                $this->db->where('id', $id);
                $this->db->delete('landing_content');
        }
        
}

?>